<?php

require 'vendor/autoload.php';
use Ramsey\Uuid\Uuid;

$token = '8029394280:AAGszv1Bs_SaBOY5HaXvvMAJ9AUGBjdQCqM';
$apiURL = "https://api.telegram.org/bot$token/";

$sendOtpUrl = "https://api.dpbms5h.club/api/public/sms/send";
$loginRegisterUrl = "https://api.dpbms5h.club/api/user/login_register";

$content = file_get_contents("php://input");
$update = json_decode($content, true);


$host = '127.0.0.1';
$dbname = 'qmnxrtxs_96in_Telegram_Bot';
$user = 'qmnxrtxs_tg_bot_user';
$pass = '_(t~2WqB&H~N';
$db_port = 3306;

$conn = new mysqli($host, $user, $pass, $dbname,$db_port);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


if (!$update) {
    exit;
}

function sendMessageWithButtons($chatId, $message, $buttons) {
    global $apiURL;
    $replyMarkup = json_encode(['inline_keyboard' => $buttons]);
    file_get_contents($apiURL . "sendMessage?chat_id=$chatId&text=" . urlencode($message) . "&reply_markup=" . urlencode($replyMarkup));
}

function sendMessage($chatId, $message) {
    global $apiURL;
    file_get_contents($apiURL . "sendMessage?chat_id=$chatId&text=" . urlencode($message));
}

function isValidPhoneNumber($phoneNumber) {
    return preg_match('/^\d{10}$/', $phoneNumber);
}

function checkTimeout($lastInteractionTime) {
    return (time() - strtotime($lastInteractionTime)) > 120; 
}

function sendDepositSteps($chatId) {
    $message = "Follow these steps to make a deposit:\n" .
    "1. Open www.96in.com\n" .
    "2. Click on Deposit\n" .
    "3. Enter amount and select payment method\n" .
    "4. Select UPI and click on place order & pay\n" .
    "5. Complete payment via your payment method\n" .
    "6. After payment is completed, check wallet balance";    
    sendMessage($chatId, $message);
}

function insertUserToDatabase($chatId, $uuid, $phoneNumber, $username, $registerTime) {
    global $conn;

    $sql = "INSERT INTO registered_users (chat_id, uuid, phone_number, username, register_time) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issss", $chatId, $uuid, $phoneNumber, $username, $registerTime);

    if ($stmt->execute()) {
        file_put_contents("log.txt", "User registered successfully and added to database: $chatId, $uuid, $phoneNumber" . PHP_EOL, FILE_APPEND);
    } else {
        file_put_contents("log.txt", "Error inserting user to database: " . $stmt->error . PHP_EOL, FILE_APPEND);
    }
}

function updateUserSession($chatId, $data) {
    global $conn;

    $sql = "INSERT INTO user_session (chat_id, uuid, phone_number, step, last_interaction) 
            VALUES (?, ?, ?, ?, NOW()) 
            ON DUPLICATE KEY UPDATE uuid = VALUES(uuid), phone_number = VALUES(phone_number), step = VALUES(step), last_interaction = NOW()";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isss", $chatId, $data['uuid'], $data['phone_number'], $data['step']);

    if ($stmt->execute()) {
        file_put_contents("log.txt", "User session updated: $chatId" . PHP_EOL, FILE_APPEND);
    } else {
        file_put_contents("log.txt", "Error updating user session: " . $stmt->error . PHP_EOL, FILE_APPEND);
    }
}

function getUserSession($chatId) {
    global $conn;

    $sql = "SELECT * FROM user_session WHERE chat_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $chatId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return null;
}
$uuid = Uuid::uuid4()->toString();

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $username = isset($message['from']['username']) ? $message['from']['username'] : null;
    $text = $message['text'];
    $currentTime = date('Y-m-d H:i:s');

    file_put_contents("log.txt", "Received message: " . $text . PHP_EOL, FILE_APPEND);
    
    $sessionData = getUserSession($chatId);



    if (strtolower(trim($text)) == '/start') {

        $buttons = [
            [['text' => 'Register now online', 'callback_data' => '1']],
            [['text' => 'Register on Telegram', 'callback_data' => '2']]
        ];
        sendMessageWithButtons($chatId, "Welcome! Choose registration method:", $buttons);

        return;
    }

    if (!$sessionData) {
        $buttons = [
            [['text' => 'Register now online', 'callback_data' => '1']],
            [['text' => 'Register on Telegram', 'callback_data' => '2']]
        ];
        updateUserSession($chatId, ['uuid' => $uuid, 'step' => 'choose_method', 'phone_number' => null]);

        sendMessageWithButtons($chatId, "Choose registration method:", $buttons);


    } elseif ($sessionData['step'] == 'choose_method') {
        if ($text == '1') {
            sendMessage($chatId, "Please visit our website to register: [Website Link](https://96in.com/en/cricket/?=undefined)");
        } elseif ($text == '2') {
            sendMessage($chatId, "Please enter your phone number:");
            updateUserSession($chatId, ['uuid' => $uuid, 'step' => 'awaiting_phone', 'phone_number' => null]);

        } else {
            sendMessage($chatId, "Invalid choice. Please reply with '1' or '2'.");
        }
    } elseif ($sessionData['step'] == 'awaiting_phone') {
        if (checkTimeout($sessionData['last_interaction'])) {
            sendMessage($chatId, "Timeout! Please enter your phone number again:");

        } else {
            $phoneNumber = trim($text);

            if (!isValidPhoneNumber($phoneNumber)) {
                sendMessage($chatId, "Invalid phone number! Please enter a valid 10-digit phone number:");

                return; 
            }

            $postData = json_encode([
                'type' => 6,
                'area_code' => 91,
                'mobile' => $phoneNumber,
                'plat_id' => 60006,
                'uuid' => $uuid,
                'device_type' => 3,
                'app_type' => 4,
                'device' => $uuid,
                'channel_id' => 60006001,
                'game_domain' => '96in.com',
                'app_plat_type' => 9,
                'lang' => 'en_EN'
            ]);

            file_put_contents("log.txt", "Post Data: " . $postData . PHP_EOL, FILE_APPEND);

            $ch = curl_init($sendOtpUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            $response = curl_exec($ch);
            curl_close($ch);

            $result = json_decode($response, true);
            file_put_contents("log.txt", "API Response: " . print_r($result, true) . PHP_EOL, FILE_APPEND);

            if (isset($result['status']) && $result['status'] === 0) {
                sendMessage($chatId, "OTP has been sent to your phone number. Please enter the OTP:");
                updateUserSession($chatId, ['uuid' => $uuid, 'step' => 'awaiting_otp', 'phone_number' => $phoneNumber]);

            } else {
                $errorMessage = isset($result['msg']) ? $result['msg'] : "An error occurred. Please try again.";
                sendMessage($chatId, $errorMessage);
            }
        }
    } elseif ($sessionData['step'] == 'awaiting_otp') {
        if (checkTimeout($sessionData['last_interaction'])) {
            sendMessage($chatId, "Timeout! Please enter your phone number again:");
            // storeData($chatId, ['step' => 'awaiting_phone', 'last_interaction' => $currentTime]);
        } else {
            $otp = trim($text);
            $phoneNumber = $sessionData['phone_number'];
            $uuid = $sessionData['uuid'];

            $postData = json_encode([
                'username' => $phoneNumber,
                'password' => 'd41d8cd98f00b204e9800998ecf8427e',
                'login_type' => 4,
                'verify_code' => $otp,
                'area_code' => 91,
                'uuid' => $uuid,
                'device_type' => 3,
                'app_type' => 4,
                'device' => $uuid,
                'plat_id' => 60006,
                'channel_id' => 60006001,
                'game_domain' => '96in.com',
                'app_plat_type' => 9,
                'lang' => 'en_EN'
            ]);

            $ch = curl_init($loginRegisterUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            $response = curl_exec($ch);
            curl_close($ch);

            $result = json_decode($response, true);

            file_put_contents("log.txt", "API Response: " . print_r($result, true) . PHP_EOL, FILE_APPEND);

            if (isset($result['status']) && $result['status'] === 0) {
                $token = $result['data']['token'];
                $user_id = $result['data']['user_id'];

                $dashboardLink = "https://96in.com/?plat_id=60006&lang=en-IN&token=$token&user_id=$user_id&uuid=$uuid";
                sendMessage($chatId, "You have successfully registered! Here is your dashboard link: $dashboardLink");
                updateUserSession($chatId, ['uuid'=> $uuid,'step' => 'registered', 'last_interaction' => $currentTime]);
                insertUserToDatabase($chatId, $sessionData['uuid'], $sessionData['phone_number'], $username, $currentTime);

                sleep(10);
                sendDepositSteps($chatId);
            } else {
                $errorMessage = isset($result['msg']) ? $result['msg'] : "Registration failed. Please check the OTP and try again.";
                sendMessage($chatId, $errorMessage);
            }
        }
    }
}

if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query'];

    $chatId = $callbackQuery['message']['chat']['id'];
    $callbackData = $callbackQuery['data'];

    if ($callbackData == '1') {

        sendMessage($chatId, "Please visit our website to register: [Website Link](https://96in.com/en/cricket/?=undefined)");
    } elseif ($callbackData == '2') {

        sendMessage($chatId, "Please enter your phone number:");
        updateUserSession($chatId, ['step' => 'awaiting_phone', 'last_interaction' => time()]);
    }
}

?>