// functions.php

<?php

require 'vendor/autoload.php';
use Ramsey\Uuid\Uuid;

// Database connection
// $host = '127.0.0.1';
// $dbname = '96in_Telegram_Bot';
// $user = 'root';
// $pass = 'root';
$host = '127.0.0.1';
$dbname = 'qmnxrtxs_96in_Telegram_Bot';
$user = 'qmnxrtxs_tg_bot_user';
$pass = '_(t~2WqB&H~N';
$db_port = 8889;
$conn = new mysqli($host, $user, $pass, $dbname, $db_port);

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

function sendPhoto($chatId, $photoPath, $caption = '') {
    global $apiURL;

    $photo = new CURLFile(realpath($photoPath));
    $url = $apiURL . "sendPhoto?chat_id=$chatId&caption=" . urlencode($caption);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, ['photo' => $photo]);
    $response = curl_exec($ch);
    curl_close($ch);

    return $response;
}

function sendMessageWithButtons($chatId, $message, $buttons, $photo = null) {
    global $apiURL;

    $replyMarkup = json_encode(['inline_keyboard' => $buttons]);
    $ch = curl_init();

    if ($photo) {
        if (!file_exists($photo)) {
            echo "Error: The file does not exist.";
            return;
        }

        $url = $apiURL . "sendPhoto";
        $postData = [
            'chat_id' => $chatId,
            'caption' => $message,
            'reply_markup' => $replyMarkup,
            'photo' => new CURLFile(realpath($photo))
        ];
    } else {
        $url = $apiURL . "sendMessage";
        $postData = [
            'chat_id' => $chatId,
            'text' => $message,
            'reply_markup' => $replyMarkup
        ];
    }

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);
}

function sendMessageWithReplyKeyboard($chatId, $text, $replyButtons) {
    global $apiURL;

    $replyMarkup = [
        'keyboard' => $replyButtons,
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];

    $params = [
        'chat_id' => $chatId,
        'text' => $text,
        'reply_markup' => json_encode($replyMarkup)
    ];

    file_get_contents($apiURL . 'sendMessage?' . http_build_query($params));
}

function sendMessage($chatId, $message) {
    global $apiURL;
    file_get_contents($apiURL . "sendMessage?chat_id=$chatId&text=" . urlencode($message));
}

function isValidPhoneNumber($phoneNumber) {
    return preg_match('/^\d{10}$/', $phoneNumber);
}

function checkTimeout($lastInteractionTime) {
    return (time() - strtotime($lastInteractionTime)) > 120;
}

function sendDepositSteps($chatId) {
    $message = 'Follow these steps to make a deposit:\n' .
        '1. Open www.96in.com\n' .
        '2. Click on Deposit\n' .
        '3. Enter amount and select payment method\n' .
        '4. Select UPI and click on place order & pay\n' .
        '5. Complete payment via your payment method\n' .
        '6. After payment is completed, check wallet balance';
    sendMessage($chatId, $message);
}

function isUsernamePresent($username) {
    global $conn;
    $sql = 'SELECT username FROM registered_users WHERE username = ?';
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $stmt->store_result();
    $isPresent = $stmt->num_rows > 0;
    $stmt->close();

    return $isPresent;
}

function insertOrUpdateUserToDatabase($chatId, $uuid, $phoneNumber, $username, $registerTime) {
    global $conn;

    $checkSql = 'SELECT phone_number FROM registered_users WHERE phone_number = ?';
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param('s', $phoneNumber);
    $checkStmt->execute();
    $checkStmt->store_result();

    if ($checkStmt->num_rows > 0) {
        $updateSql = 'UPDATE registered_users SET chat_id = ?, uuid = ?, username = ?, register_time = ? WHERE phone_number = ?';
        $updateStmt = $conn->prepare($updateSql);
        $updateStmt->bind_param('issss', $chatId, $uuid, $username, $registerTime, $phoneNumber);

        if ($updateStmt->execute()) {
            file_put_contents('log.txt', "User information updated successfully in database: $chatId, $uuid, $phoneNumber" . PHP_EOL, FILE_APPEND);
        } else {
            file_put_contents('log.txt', 'Error updating user information in database: ' . $updateStmt->error . PHP_EOL, FILE_APPEND);
        }

        $updateStmt->close();
    } else {
        $insertSql = 'INSERT INTO registered_users (chat_id, uuid, phone_number, username, register_time) VALUES (?, ?, ?, ?, ?)';
        $insertStmt = $conn->prepare($insertSql);
        $insertStmt->bind_param('issss', $chatId, $uuid, $phoneNumber, $username, $registerTime);

        if ($insertStmt->execute()) {
            file_put_contents('log.txt', "User registered successfully and added to database: $chatId, $uuid, $phoneNumber" . PHP_EOL, FILE_APPEND);
        } else {
            file_put_contents('log.txt', 'Error inserting user to database: ' . $insertStmt->error . PHP_EOL, FILE_APPEND);
        }

        $insertStmt->close();
    }

    $checkStmt->close();
}

function updateUserSession($chatId, $data) {
    global $conn;

    $sql = "INSERT INTO user_session (chat_id, uuid, phone_number, step, token, user_id, last_interaction) 
            VALUES (?, ?, ?, ?, ?, ?, NOW()) 
            ON DUPLICATE KEY UPDATE 
                uuid = VALUES(uuid), 
                phone_number = VALUES(phone_number), 
                step = VALUES(step), 
                token = VALUES(token), 
                user_id = VALUES(user_id), 
                last_interaction = NOW()";

    $stmt = $conn->prepare($sql);

    $uuid = isset($data['uuid']) ? $data['uuid'] : null;
    $token = isset($data['token']) ? $data['token'] : null;
    $userId = isset($data['user_id']) ? $data['user_id'] : null;

    $stmt->bind_param('isssss', $chatId, $uuid, $data['phone_number'], $data['step'], $token, $userId);

    if ($stmt->execute()) {
        file_put_contents('log.txt', "User session updated: $chatId" . PHP_EOL, FILE_APPEND);
    } else {
        file_put_contents('log.txt', 'Error updating user session: ' . $stmt->error . PHP_EOL, FILE_APPEND);
    }
}

function getUserSession($chatId) {
    global $conn;

    $sql = 'SELECT * FROM user_session WHERE chat_id = ?';
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $chatId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return null;
}
?>
